// *************************************************************************************************
// PURPOSE:
// List all of the pages in a site
// *************************************************************************************************
// USAGE:
//    1. Update the groupId and privateGroup variables
//    2. Run the script
// *************************************************************************************************

import com.liferay.portal.service.GroupLocalServiceUtil
import com.liferay.portal.service.LayoutLocalServiceUtil
import com.liferay.portal.kernel.log.LogFactoryUtil
import java.text.SimpleDateFormat
import java.util.stream.Collectors
import java.util.TimeZone

def groupId = 236376
def privateGroup = false
def locale = new Locale("en", "AU")

def group = GroupLocalServiceUtil.getGroup(groupId)
out.println("Listing site inventory for site: " + group.getDescriptiveName(locale))
out.println()

def sdf = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss")
sdf.setTimeZone(TimeZone.getTimeZone("Australia/Melbourne"))

out.println('"Title","Friendly URL","Sitemap","Created","Last Modified"')
for (layout in LayoutLocalServiceUtil.getLayouts(groupId, privateGroup).sort{it -> it.getHTMLTitle(locale).toLowerCase()}) {
	out.print('"')
	out.print(layout.getHTMLTitle(locale))
	out.print('","')
	out.print(layout.getFriendlyURL(locale))
	out.print('","')
	
	def ancestors = '';
	layout.getAncestors().each {
		ancestor -> ancestors = ancestor.getName(locale) + '/' + ancestors
	}
	out.print((privateGroup ? 'Private Pages/' : 'Public Pages/') + ancestors + layout.getName(locale))
	out.print('","')
	out.print(sdf.format(layout.getCreateDate()))
	out.print('","')
	out.print(sdf.format(layout.getModifiedDate()))
	out.print('"')
	out.println()
}

out.println()
out.println("Done")